// List.h: interface for the List class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LIST_H__F826C232_02B5_42CA_A99C_2EB3869CA01E__INCLUDED_)
#define AFX_LIST_H__F826C232_02B5_42CA_A99C_2EB3869CA01E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <fstream.h>
#include "nodes.cpp"

//List class uses the node (composition) for maintaing the list

template <class T>

class List
{
	public:
		List();										//Default Constructor
		List(const List<T> &);						//Copy Constructor
		~List();									//Destructor
		void Delete_List();							//Delete the whole List
		void Insert_Node(const T &);				//Insert a new node in the list
		void Insert_At_Front(const T &);			//Insert a new node at the first of the list
		void Delete_Node(const T &);				//Delete a node from the list
		void Display_List(char*,ostream &) const;	//Display the whole List		
		int Get_size() const;						//return the size of the list
		T Get_Customer();							//Returns the Customers address
		bool Check_Customer(T&);					//checks that the desired customer is in the 
													//list or not
	
		List& operator = (const List<T> &);			//Assignment operator		

	private:
		Node<T> *Head;				// Head which remains at the start
		Node<T> *Tail;				// Tail which moves with the insertion of new node

		int size;					// stores the size of the list
};


#endif // !defined(AFX_LIST_H__F826C232_02B5_42CA_A99C_2EB3869CA01E__INCLUDED_)
